;;
SpAsm GUID Generator 0.2
Eric Asbell (RobotBob)
easbell@quanta-it.com
April 3rd 2003
SpAsm needed a GUID Generator!
Creates a GUID, a unique 128-bit integer used for CLSIDs and interface identifiers.
And places the resulting code snippet into the clipboard for easy pasting into SpAsm.
 
Quote from MSDN:
The CoCreateGuid function calls the RPC function UuidCreate, which creates a GUID, 
a globally unique 128-bit integer. Use the CoCreateGuid function when you need an 
absolutely unique number that you will use as a persistent identifier in a distributed 
environment.To a very high degree of certainty, this function returns a unique value   
no other invocation, on the same or any other system (networked or not), should return 
the same value.
;;

[push | push #1 | #+1]  
[pop | pop #1 | #+1]     
[call | push #L>2 | call #1]

[pGUID:
 Data1: D$ 0
 Data2: W$ 0
 Data3: W$ 0]
[Data4: B$ 0 #8]

[Result: B$ 'The GUID code is in the clipboard' 0]
[pClip: D$ 0]

[FirstDword: B$ 0 #20]
[FirstWord: B$ 0 #20]
[SecondWord: B$ 0 #20]
[EightBytes: B$ 0 #33]

[SpAsmGUIDTemplate: B$ "[GUIDNAME:
Data1: D$ 0%sH
Data2: W$ 0%sH
Data3: W$ 0%sH]
[Data4: B$ 0%s 0%s 0%s 0%s 0%s 0%s 0%s 0%s]" 0]

[MasmGUIDTemplate: B$ "GUIDNAME     TEXTEQU     <{0%sH, 0%sH, 0%sH, \
                       {0%sH, 0%sH, 0%sH, 0%sH, 0%sH, 0%sH, 0%sH, 0%sH}}>" 0]

[GUIDTextBufferW: B$ 0 #255]
[GUIDTextBufferA: B$ 0 #255]

[OutPutBuffer: B$ ? #100]

Main:
        ; Must be here like InitCommon... and WSAStartup
        call 'OLE32.CoInitializeEx' &NULL &COINIT_APARTMENTTHREADED
        
        ; See the quote from msdn for explanation         
        call 'OLE32.CoCreateGuid' pGUID
        
        ; It take the GUID structure and converts it to ascii unicode
        call 'OLE32.StringFromGUID2' pGUID GUIDTextBufferW 255
        
        call 'KERNEL32.WideCharToMultiByte' &CP_ACP 0 GUIDTextBufferW 255 GUIDTextBufferA &MAX_PATH &NULL &NULL
        
        mov esi GUIDTextBufferA | inc esi
        
        mov edi FirstDword | mov ecx 8 | rep movsb | inc esi        
        mov edi FirstWord | mov ecx 4 | rep movsb | inc esi
        mov edi SecondWord | mov ecx 4 | rep movsb | inc esi               
        mov edi EightBytes
        
        mov ecx 2 | rep movsb
        mov B$edi 0 | inc edi
        
        mov ecx 2 | rep movsb
        mov B$edi 0 | inc edi
        
        inc esi
        
        mov ecx 7
L1:             
        push ecx| mov ecx 2 | rep movsb
        mov B$edi 0 | inc edi | pop ecx
        
        loop L1<
        
        mov esi EightBytes
        add esi 21 | push esi
        sub esi 3 | push esi
        sub esi 3 | push esi
        sub esi 3 | push esi
        sub esi 3 | push esi
        sub esi 3 | push esi
        sub esi 3 | push esi
        push esi
        push SecondWord
        push FirstWord
        push FirstDword
        push MasmGUIDTemplate ;SpAsmGUIDTemplate
        push OutPutBuffer       
        call 'USER32.wsprintfA'
                                
        add esp 034        
                                     
        call 'USER32.MessageBoxA' 0 GUIDTextBufferA Result 0
        call 'USER32.MessageBoxA' 0 OutPutBuffer Result 0           
       
        ; Free OLE32                 
        call 'OLE32.CoUninitialize'
         
        call 'KERNEL32.ExitProcess' 0
        ret




